//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%
//% Hbook interface.
//%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

#ifndef _CHBOOK
#define _CHBOOK 1


#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>

#include "MAF_GList.h"
#include "MAF_Constants.h"


// #ifndef __MACHTEN_PPC__
extern "C" { 
extern  void hrput_(int *i, char *fn, char *mode, int len1, int len2);
extern  void pawc4m_();
extern  void hbook1_(int *id0, char *title, int *nbin, float *min, float *max, 
		     float *nw, int nchar);
extern  void hbook2_(int *id0, char *title, int *xbin, float *xmin, float *xmax, 
		     int *ybin, float *ymin, float *ymax, float *nw, int nchar);
extern  void hfill_(int *id, float *val, float *yval, float *w);
extern  void hf_fint(char *option); /* to initialize fortran environment */

extern  void hplot_(int *id, char *fn, char *mode, int *num, int len1, int len2);
extern  void hplint_(int *iwktyp);
extern  void hplopt_(char *opt, int *i, int len);
extern  void igwkty_(int *iwktyp);
extern  void igmeta_(int *iwktyp, int *metafiletype);
extern  void hplzon_(int *nx, int *ny, int *ifirst, char *s, int len);
extern  void hplend_();
extern void hplset_(char *opt, int *value, int len);
extern void htitle_(char *title, int len);
extern void hfithn_(int *idnow, char *chfunc, char *chopt, int *np, 
            float par[], float step[], float pmin[], float pmax[], 
            float sigpar[], float *chisq, int lchfunc, int lchopt);
extern  float hstati_(int *id, int *icase, char *choice, int *num, int lchoise);
extern  void hunpak_(int *id, float conten[], char *choice, int *num, int lchoice);
extern  void hgive_(int *id, char *chtitl, int *nx, float *xmi, float *xma,
                  int *ny, float *ymi, float *yma, int *nwt, int *loc, int lch);
extern  void hix_(int *id, int *bin, float *x);
extern  void hxi_(int *id, float *x, int *i);
extern  float hi_(int *id, int *i);
extern  float hx_(int *id, float *x);
extern  void hbpro_(int *id, float *vmx);
extern  void hbprox_(int *id, float *vmx);
extern  void hbproy_(int *id, float *vmx);
extern  void hbandx_(int *id, float *ymi, float *yma, float *vmx);
extern  void hbandy_(int *id, float *ymi, float *yma, float *vmx);


extern  void openhplotfile_(int *id, char *file, int len);
extern  void closefile_(int *id);

 }
// #endif

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
struct HB {
  int id;
  char *name;
  int nbin;
  float min, max, xnw;
  int ybin;
  float ymin, ymax ;
  int ndim;
  HB(int i, char *n, int nb, float xmin, float xmax, float xxnw);
  HB(int i, char *n, int nb, float xmin, float xmax, 
                     int ybin, float ymin, float ymax, float w);
  ~HB(){
    delete  name;
  };
  void Print();
};

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
struct HBstat
{
   float mean, rms, entry;
 };

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
struct HBpara
{
   int id;
   char chtitl[90];
   int nx ; float xmi, xma ;
   int ny ; float ymi, yma ;
   int nwt, loc;
   void Print();
 };


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
class CHbook : MAF_GList {
  static int lastHid;
  int idbase;
  static char *hbookoutfile;
 public:
  CHbook() : MAF_GList(){}
  ~CHbook(){}
  void append(HB *a){  MAF_GList::append((void *)a); }

  HB *get(){ return (HB *) MAF_GList::get();}
  HB *next(int start);
  void Hbook1(int id, char *name, int nbin, float min, float max, float xnw);
  void Hbook2(int id, char *name, int xbin, float xmin, float xmax, 
	                          int ybin, float ymin, float ymax, float w);
  void Hfill( int id, float x, float y, float w);
  void Hplot( int id, char *chopt, char *chcase, int num);
  void Htitle(char *title);
  void Hfithn(int id, char *chfunc, char *chopt, int np, 
     float par[], float step[], float pmin[], float pmax[], float sigpar[], float& chisq);
  HBstat& Hstati(int id, char *choice, int num);
  void Hunpak(int id, float conten[], char *choise, int num);
  HBpara& Hgive(int id);
  int&    Hxi(int id, float x);
  float&  Hix(int id, int bin);
  float& Hi(int id, int ibin);
  float& Hx(int id, float x);

  int& IdBase(int id){ static int idnow=idbase+id ; return idnow ; }

  void DoHbook();
  void Print();
//  void SetFileName(char *file);

  int Terminate();
  void Initialize();

  int SetParameters(char *parm);

//  void hbook1(int id, char *name, int nbin, float min, float max, float xnw);
//  void hbook2(int id, char *name, int xbin, float xmin, float xmax, 
//	      int ybin, float ymin, float ymax, float w);
//  void hfill( int id, float x, float y, float w);
};

#endif
