#include "MAF_GList.h"
#include "CHbook.h"

int CHbook::lastHid=-1;
char *CHbook::hbookoutfile="dis.file";

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
float& CHbook::Hi(int id, int bin)
{
  int idnow=id+idbase;
  float var=hi_(&idnow, &bin);
  return var;
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
float& CHbook::Hx(int id, float x)
{
  int idnow=id+idbase;
  float var=hx_(&idnow, &x);
  return var;
}


// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
int& CHbook::Hxi(int id, float x)
{
  int idnow=id+idbase;
  int ans;
  hxi_(&idnow, &x, &ans);
  return ans;
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
float& CHbook::Hix(int id, int bin)
{
  int idnow=id+idbase;
  float ans;
  hix_(&idnow, &bin, &ans);
  return ans;
}


// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// Hunpak returns histogram contents in the array conten
//
void CHbook::Hunpak(int id, float conten[], char *choice, int num)
{
  int lchoice=strlen(choice)+1;
  int idnow=id+idbase;
  hunpak_(&idnow, conten, choice, &num, lchoice);
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// Hgive returns booking parameters
//
HBpara& CHbook::Hgive(int id)
{
  int idnow=id+idbase;
  HBpara ans;
  ans.id=id;
  hgive_(&idnow, &ans.chtitl[0], &ans.nx, &ans.xmi, &ans.xma,
         &ans.ny, &ans.ymi, &ans.yma, &ans.nwt, &ans.loc, 90);
  return ans;
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void HBpara::Print()
{
  cout << " ID= " << id ;
  cout << " Title=" << chtitl << endl ;
  cout << " (nx,xmi,xma)=(" << nx << "," << xmi << "," << xma << ")" ;
  cout << " (ny,ymi,yma)=(" << ny << "," << ymi << "," << yma << ")" ;
  cout << " nwt=" << nwt << " loc = " << loc << endl ;
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void CHbook::Hfithn(int id, char *chfunc, char *chopt, int np, 
     float par[], float step[], float pmin[], float pmax[], float sigpar[], float& chisq)
{
  int lchfunc=strlen(chfunc)+1;
  int lchopt=strlen(chopt)+1;
  int idnow=id+idbase;
  hfithn_(&idnow, chfunc, chopt, &np, par, step, pmin, pmax, sigpar, &chisq, lchfunc, lchopt);
} 

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
HBstat& CHbook::Hstati(int id, char *choice, int num)
{
  int idnow=id+idbase;
  int lchoice=strlen(choice)+1;
  HBstat a ; int icase ;
  icase=1;   a.mean=hstati_(&idnow, &icase, choice, &num, lchoice);
  icase=2;   a.rms=hstati_(&idnow, &icase, choice, &num, lchoice);
  icase=3;   a.entry=hstati_(&idnow, &icase, choice, &num, lchoice);
  return a;
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void  CHbook::Hfill(int id, float x, float y, float w)
{
  int idnow=id+idbase ;
  hfill_(&idnow, &x, &y, &w);
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void  CHbook::Hplot(int id, char *chopt, char *chcase, int num)
{
  int idnow;
  if( id == 0 ) { idnow = 0 ; } 
  else { idnow=id+idbase ; } 
  int lopt=strlen(chopt);
  int lcase=strlen(chcase);
  hplot_(&idnow, chopt, chcase, &num , lopt, lcase);
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void  CHbook::Htitle(char *title)
{
  int ltitle=strlen(title);
  htitle_(title, ltitle);
}


// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
HB *CHbook::next(int start)
{ 
  return (HB *) MAF_GList::next(start);
}


// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void CHbook::Hbook1(int id, char *name, int nbin, float min, float max, float xnw)
{
     HB *hb=new HB(id, name, nbin, min, max, xnw) ;
     MAF_GList::append((void *)hb);
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void CHbook::Hbook2(int id, char *name, int nbin, float min, float max, 
		                        int ybin, float ymin, float ymax , float xnw)
{
     HB *hb=new HB(id, name, nbin, min, max, ybin, ymin, ymax, xnw) ;
     MAF_GList::append((void *)hb);
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void CHbook::Print()
{
  for ( HB *hb=next(1) ; hb != NULL ; hb=next(0)){
    printf(" hid %d  title %s nbin %d xmin %f max %f \n",
        hb->id, hb->name, hb->nbin, hb->min, hb->max);
  }
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void CHbook::Initialize()
{

  if( lastHid < 0 ) { 
#ifndef __MACHTEN_PPC__
    hf_fint((char *)NULL);
#endif
    pawc4m_();
    lastHid=10;
  }

  DoHbook();
}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
int CHbook::SetParameters(char *parm)
{
  char name[128], value[128];
  int id, nbin, ybin;
  float min, max, ymin, ymax ;
  sscanf(parm, "%s %s", name, value);
  if( strcmp(name,"Hbook1") == 0 ) {
    sscanf(parm, "%s %d %d %f %f", value, &id, &nbin, &min, &max) ;
//    cout << " id is " << id  << endl ; 
    for ( HB *hb=next(1) ; hb != NULL ; hb=next(0)){
      if( hb->id == id ) { 
        if( hb->ndim != 1 ) { 
           cout << "Change Hbook1 parameter is requested, but hid is for Hbook2 " << endl ;
           cout << "Input was " << parm << endl ;
           return NOTFOUND;
	 }
         hb->nbin=nbin;   hb->min=min;   hb->max=max;
         hb->Print();
//         cout << " Hbook1 parameter is changed for id= " << id << endl ;
         return CONT;
       }
     }
     cout << "Corresponding histogram not found, Wrong input was " << endl;
     cout << parm << endl ;
     return NOTFOUND;
  }
  else if ( strcmp(name, "Hbook2") == 0 ) {
    sscanf(parm, "%s %d %d %f %f %d %f %f ", value, &id, &nbin, &min, &max, &ybin, &ymin, &ymax) ;
    for ( HB *hb=next(1) ; hb != NULL ; hb=next(0)){
      if( hb->id == id ) { 
        if( hb->ndim != 2 ) { 
           cout << "Change Hbook2 parameter is requested, but hid is for Hbook1 " << endl ;
           cout << "Input was " << parm << endl ;
           return NOTFOUND;
	 }
         hb->nbin=nbin;   hb->min=min;   hb->max=max;
         hb->ybin=ybin;   hb->ymin=ymin;   hb->ymax=ymax;
         hb->Print();
         return CONT;
       }
     }
     cout << "Corresponding histogram not found, Wrong input was " << endl;
     cout << parm << endl ;
     return NOTFOUND;
  }
  else if ( strcmp(name, "HbookOutfile") == 0 ) {
     int ln=strlen(value);
     hbookoutfile=new char[ln+1];
     hbookoutfile=strcpy(hbookoutfile,value);
     return CONT;
  }
  return NOTFOUND;
}


// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void CHbook::DoHbook()
{
  int idnow ;
  int idmax=0;
  idbase=lastHid;
  for ( HB *hb=next(1) ; hb != NULL ; hb=next(0)){
    if( hb->ndim == 1 ) { 
//      printf(" hid %d  title %s nbin %d xmin %f max %f \n",
//          hb->id, hb->name, hb->nbin, hb->min, hb->max);
      int lw=strlen(hb->name);
      idnow = hb->id + lastHid ;
      hbook1_(&idnow, hb->name, &hb->nbin, &hb->min, &hb->max, &hb->xnw, lw);
      if( idnow >= idmax ) { idmax=idnow; }
    } 
    else {
//      printf(" hid %d  title %s xbin %d xmin %f max %f ybin %d ymin %f ymax %f \n",
//          hb->id, hb->name, hb->nbin, hb->min, hb->max, 
//	  hb->ybin, hb->ymin, hb->ymax );
      int lw=strlen(hb->name);
      idnow = hb->id + lastHid ;
      hbook2_(&idnow, hb->name, &hb->nbin, &hb->min, &hb->max, 
	      &hb->ybin, &hb->ymin, &hb->ymax, &hb->xnw, lw);
      if( idnow >= idmax ) { idmax=idnow; }
    }
  }
  lastHid = idmax ; 
  cout << " LastHid is " << lastHid << endl ;

}

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
HB::HB(int i, char *n, int nb, float xmin, float xmax, float xxnw)
{
    ndim=1 ; id=i ; nbin=nb ; min=xmin ; max=xmax ; xnw=xxnw;
    name=new char[strlen(n)+1];
    name=strcpy(name, n); 
 }


// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
HB::HB(int i, char *n, int nb, float xmin, float xmax, 
                       int yb, float ymn, float ymx, float xxnw)
{
    ndim=2 ; id=i ; nbin=nb ; min=xmin ; max=xmax ; xnw=xxnw;
    ybin=yb ; ymin=ymn ; ymax=ymx ; xnw=xxnw;
    name=new char[strlen(n)+1];
    name=strcpy(name, n); 
 }

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void HB::Print()
{
  if( ndim == 1 ) {
    printf("Hid %d  Title(%s) (bin,min,max)=(%d,%f,%f) \n", id, name, nbin, min, max );
  }
  else {
    printf("Hid %d  Title(%s) X(bin,min,max)=(%d,%f,%f) Y(bin,min,max)=(%d,%f,%f) \n", 
	   id, name, nbin, min, max , ybin, ymin, ymax);
  }
}



// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
int CHbook::Terminate()
{
  int mode=0;
  static int ncall=0;  

  ncall++;
  
  if(ncall == 1 ) { 
    int lc = strlen(hbookoutfile);
    hrput_(&mode, hbookoutfile, "n", lc, 1);
  }
  return CONT ; 
}



